$(document).ready(function() {
    
    /* Add menu items and classes */
    $('.custom-menu-primary').addClass('js-enabled');
    $('.custom-menu-primary .hs-menu-wrapper').before('<div class="mobile-trigger"><i></i></div>');
    $('.custom-menu-primary .hs-menu-wrapper').append('<div class="close-menu"></div>');
    
    $('.custom-menu-primary .hs-menu-wrapper > ul > .hs-item-has-children > a').before('<div class="child-trigger">+</div>');
    $('.custom-menu-primary .hs-menu-wrapper > ul > li').wrapInner('<div class="child-items"/>');
    
    $('.custom-menu-primary .hs-menu-wrapper > ul > li').click(function() {
        $('body').removeClass('menu-open');
        $('.custom-menu-primary').removeClass('open');
        $('.custom-menu-primary').addClass('closed');
    });
    $('.child-trigger').click(function() {
        $(this).parent().parent().siblings('.hs-item-has-children').find('.child-trigger').removeClass('child-open');
        $(this).toggleClass('child-open');
        return false;
    });
    
    /* Bind open/close buttons for mobile nav overlay */
    $('.mobile-trigger').on('click', function() {
        $('body').addClass('menu-open');
        $('.custom-menu-primary').addClass('open');
    });  
    $('.close-menu').on('click', function() {
        $('body').removeClass('menu-open');
        $('.custom-menu-primary').removeClass('open');
        $('.custom-menu-primary').addClass('closed');
    });
    
    /* Close menu on ESC key */
    $(document).keyup(function(e){
        if(e.keyCode === 27) {
            $('body').removeClass('menu-open');
            $('.custom-menu-primary').removeClass('open');
            $('.custom-menu-primary').addClass('closed');
        }
    });

    /* Move Homepage RSS Featured Image to BG Image */
    $('.hs-rss-featured-image').each(function() {
        imageUrl = $(this).attr('src');
        $(this).parent('.hs-rss-item-image-wrapper').css('background-image', 'url(' + imageUrl + ')');
        $(this).remove();
    });

});

/* Sticky Footer */
function updateHeight(){
    var bodyHeight = $( window ).height() - $('.header-container-wrapper').outerHeight() - $('.footer-container-wrapper').outerHeight();
    $('.body-container-wrapper').css('min-height', bodyHeight + 'px');
}
updateHeight();
$(window).on("resize", updateHeight);

/* Adds class to parent element of <select> */
$(window).load(function() {
    $('select').parent().addClass('hs-select');
});